---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Multi-path (redundant) (pattern)

> Parallel routes provide redundancy and higher resilience.

---

## Definition

- Multiple parallel paths between points
- Independent routes for redundancy
- Load sharing across paths
- Merge reconciliation at endpoints

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Path diversity | Route set | `Monitor`, `Paths` |
| Load balance | Traffic split | `Check`, `Load` |
| Merge sync | State merge | `Sync`, `Merge` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Path diversity | Multiple ways | "Many paths" |
| Load balance | Shared effort | "Split load" |
| Merge sync | Coming together | "All joins up" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Route set | Multiple ways | How diversity works |
| Traffic split | Shared effort | How balance works |
| State merge | Coming together | How unity forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Wave paths | Energy spread |
| Networks | Route mesh | Message web |
| Cognition | Neural web | Thought paths |
| Systems | Process web | Action mesh |

---

## Scale Effects

How Multi-path pattern manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Path quantum | Wave paths |
| λV | Gate mesh | State web |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Path binding | Memory web |
| ∇S | Path clarity | Clear options |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Path limits | Light web |
| λV | Field mesh | Space web |

Note: At extreme scales, multi-path behavior faces fundamental limits (e.g., quantum interference at ε, causal webs at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: aggregate signal > threshold
- c: paths within capacity
- ψA: merge window sufficient
- λV: diverse gates viable

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Path separation | Option clarity |
| Human | λV | Gate diversity | Flow choices |
| Cosmic | ψA | Path binding | Web coherence |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Path coupling | Interference | Lost separation |
| Human | Merge fail | Sync loss | Can't combine |
| Cosmic | Web break | Structure loss | Lost connection |

---

## Diagnostic Checklist

Technical tests:
- [ ] Paths are independent
- [ ] Load balancing works
- [ ] Merge window sufficient
- [ ] No hidden bottlenecks

Humane tests:
- [ ] Paths feel separate
- [ ] Load feels shared
- [ ] Joins smoothly
- [ ] No single points

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical redundancy nor experiential diversity alone captures its full meaning.

---

## See Also

- [[Path (chain) (pattern)]]
- [[Cycle (feedback loop) (pattern)]]
- [[Bridge / Articulation (pattern)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented